
/** *************************************************************************
*** AMXX Plugin:   World of Warcraft Mod (WowMOD)
*** Plugin Author: K2mia
*** WowMOD Module:  Main
*** Date:          Aug 09, 2007
*** Last Update:   Feb 02, 2008
*
*   World of Warcraft Mod continues in the tradition of UWC3 for CS 1.6, providing
*  a level-based RPG experience within the realm of the CS FPS. Many aspects are
*  borrowed from UWC3 (also by K2mia) including some skills and underlying themes.
*
*  Module: Main
*  Module Description:
*  This module provides the plugin initialization, client connection/disconnection
*  handling and other misc shared routines that are used throughout the mod.
*
*  Licensing Info:
*  You are free to use and modify this plugin to your liking with the following
*  restrictions:
*  a) You cannot altar the header/license/credit info in the sourcecode
*  b) You cannot altar/remove/replace the credits screen defined in the
*     wowmod_info_credits subroutine
*  c) You cannot altar/remove/replace the register_plugin() call in wowmod.sma
*----------------------------------------------------------------------------
*
*  WowMOD is written exclusively for AMX Mod X by K2mia
*  
****************************************************************************/

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>
#include <cstrike>
#include <string>
#include <fun>
#include <dbi>

#include "include/wowmod_defs.inc" 		   // Include the WowMOD #defines file
#include "include/wowmod_vars.inc" 		   // Include the WowMOD global variables file
#include "include/wowmod_utility.inc" 	   // Include the WowMOD utility module
#include "include/wowmod_events.inc"  	   // Include the WowMOD events module
#include "include/wowmod_dmgevents.inc"	// Include the WowMOD damage events module
#include "include/wowmod_races.inc"   	   // Include the WowMOD races module
#include "include/wowmod_classes.inc" 	   // Include the WowMOD classes module
#include "include/wowmod_menus.inc"   	   // Include the WowMOD menus module
#include "include/wowmod_huds.inc" 		   // Include the WowMOD huds module
#include "include/wowmod_storage.inc"		// Include the WowMOD storage module
#include "include/wowmod_xp.inc"   		   // Include the WowMOD xp module
#include "include/wowmod_spells.inc" 		// Include the WowMOD spells module
#include "include/wowmod_infoandhelp.inc" // Include the WowMOD info and help module
#include "include/wowmod_merchant.inc"    // Include the WowMOD merchant module
#include "include/wowmod_help.inc"    	   // Include the WowMOD help module
#include "include/wowmod_gear.inc"    	   // Include the WowMOD gear module
#include "include/wowmod_saycmds.inc"     // Include the WowMOD spoken-cmds module
#include "include/wowmod_badges.inc"      // Include the WowMOD badges module
#include "include/wowmod_effects.inc"     // Include the WowMOD effects module

#pragma dynamic 65536           // Give the plugin some extra memory to use

// **************************************************************************
// BEGIN subroutine declarations section
// **************************************************************************

// **************************************************************************
// BEGIN plugin_init subroutine
// Plugin Initialization and Registration
// **************************************************************************
public plugin_init(){

   register_plugin( "World of Warcraft Mod (WowMOD)", VER, "K2mia cswowmod.com")

   // Set messagning variables
   gmsgDeathMsg = get_user_msgid("DeathMsg")
   gmsgShake = get_user_msgid("ScreenShake")
   gmsgStatusText = get_user_msgid("StatusText")

   // [09-13-04] Nasty exploit, this prevents it - K2mia
   register_clcmd("fullupdate", "fullupdate")

   // Client command entries follow
   register_clcmd( "racemenu", "wowmod_display_racemenu", -1,
      "- Display the WowMOD Race Menu")
   register_clcmd("save", "wowmod_save", -1,
      "- In long term XP mode, saves your player data")

   register_clcmd( "say", "check_say")
   register_clcmd( "say_team", "check_say")

   register_clcmd( "admin_res", "wowmod_display_resurrect", ADMIN_MENU,
      "- WowMOD CMD: Admin-Only: Debug Resurrect Spell" )
   register_clcmd( "admin_godmode", "wowmod_admin_godmode", -1,
      "- WowMOD CMD: Admin-Only: Enable Godmode ( for DEBUG purposes only )" )
   register_clcmd( "admin_lookup_item", "wowmod_admin_lookupitem", -1,
      "- WowMOD CMD: Admin Command - Lookup an item's gid by its name" )
   register_clcmd( "admin_load_item", "wowmod_admin_loaditem", -1,
      "- WowMOD CMD: Admin Command - Load an item by its gid" )
   register_clcmd( "admin_shutdown_wowmod", "wowmod_admin_shutdown", -1,
      "- WowMOD CMD: Admin Command - Disable WowMOD from running" )

   // Commands for bindable menu popups
   register_clcmd( "/wowmod", "wowmod_display_mainmenu", -1,
      "- WowMOD Menu: Main Menu" )
   register_clcmd( "/wow", "wowmod_display_mainmenu", -1,
      "- WowMOD Menu: Main Menu" )
   register_clcmd( "/wowmenu", "wowmod_display_mainmenu", -1,
      "- WowMOD Menu: Main Menu" )
   register_clcmd( "/charsheet", "wowmod_info_charsheet", -1,
      "- WowMOD Menu: Your Character Sheet" )
   register_clcmd( "/spells", "wowmod_info_charsheet2", -1,
      "- WowMOD Menu: Your Known Spells" )
   register_clcmd( "/spellmenu", "wowmod_display_spellmerchant", -1,
      "- WowMOD Menu: Spells Merchant" )
   register_clcmd( "/worn", "wowmod_info_worn", -1,
      "- WowMOD Menu: Display Your Worn Equipment" )
   register_clcmd( "/inv", "wowmod_info_inventory", -1,
      "- WowMOD Menu: Display Your Inventory" )
   register_clcmd( "/wowstats", "wowmod_info_stats", -1,
      "- WowMOD Menu: Display Your WowMOD Stats" )
   register_clcmd( "/mybadges", "wowmod_info_mybadges", -1,
      "- WowMOD Menu: Display Your Earned WowMOD Badges" )


   // Commands for WowMOD bindable racial abilities
   register_clcmd( "wow_racial", "wowmod_racial_chooser", -1,
      "- WowMOD Racial: Triggers your specific Racial ability" )
   register_clcmd( "wow_shadow", "wowmod_racial_shadow", -1,
      "- WowMOD Racial: Nightelf racial ability, turn invisible once per round" )
   register_clcmd( "wow_escape", "wowmod_racial_escape", -1,
      "- WowMOD Racial: Gnome racial ability, escape from root or snares once per round" )
   register_clcmd( "wow_stoneform", "wowmod_racial_stone", -1,
      "- WowMOD Racial: Dwarf racial ability, stoneform resists damage over time once per round" )
   register_clcmd( "wow_perception", "wowmod_racial_perception", -1,
      "- WowMOD Racial: Human racial ability, can easily spot all enemy players once per round" )
   register_clcmd( "wow_berzerk", "wowmod_racial_berzerk", -1,
      "- WowMOD Racial: Orc racial ability, increase all base damage once per round" )
   register_clcmd( "wow_warstomp", "wowmod_racial_warstomp", -1,
      "- WowMOD Racial: Tauren racial ability, stuns all nearby enemies once per round" )
   register_clcmd( "wow_cannibal", "wowmod_racial_cannibal", -1,
      "- WowMOD Racial: Undead racial ability, quick regeneration once per round" )
   register_clcmd( "wow_manatap", "wowmod_racial_manatap", -1,
      "- WowMOD Racial: Bloodelf racial ability, drain/steal mana from a targetted enemy once per round" )

   // Commands for WowMOD bindable spells
   register_clcmd( "wow_healtouch", "wowmod_spell_healtouch", -1,
      "- WowMOD Spell: Heals a teamate's wounds ( target teamate and trigger 'wow_healtouch' cmd )" )
   register_clcmd( "wow_heal", "wowmod_spell_heal", -1,
      "- WowMOD Spell: Heals a teamate's wounds ( target teamate and trigger 'wow_heal' cmd )" )
   register_clcmd( "wow_lesserheal", "wowmod_spell_lesserheal", -1,
      "- WowMOD Spell: Heals a teamate's wounds ( target teamate and trigger 'wow_heal' cmd )" )
   register_clcmd( "wow_remcurse", "wowmod_spell_remcurse", -1,
      "- WowMOD Spell: Attempts to cure a cursed ( target teamate and trigger 'wow_remcurse' cmd )" )
   register_clcmd( "wow_giftwild", "wowmod_spell_giftwild", -1,
      "- WowMOD Spell: Grants Gift of the Wild to a teamate ( target teamate and trigger 'wow_giftwild' cmd )" )
   register_clcmd( "wow_roots", "wowmod_spell_roots", -1,
      "- WowMOD Spell: Attempts to root your enemy to the ground ( target enemy and trigger 'wow_roots' cmd )" )
   register_clcmd( "wow_aimed", "wowmod_dmgspell_aimed", -1,
      "- WowMOD Spell: Attempts to hit your enemy with an Aimed Shot ( target enemy and trigger 'wow_aimed' cmd )" )
   register_clcmd( "wow_frostbolt", "wowmod_dmgspell_frostbolt", -1,
      "- WowMOD Spell: Attempts to hit your enemy with a Frostbolt ( target enemy and trigger 'wow_frostbolt' cmd )" )
   register_clcmd( "wow_flamestrike", "wowmod_dmgspell_flamestrike", -1,
      "- WowMOD CMD: Call down a pillar of flames to engulf your enemies ( target area and trigger 'wow_flamestrike' cmd )" )
   register_clcmd( "wow_blizzard", "wowmod_dmgspell_blizzard", -1,
      "- WowMOD CMD: Invoke a blizzard to engulf your enemies ( target area and trigger 'wow_blizzard' cmd )" )
   register_clcmd( "wow_blink", "wowmod_spell_blink", -1,
      "- WowMOD CMD: Teleports the mage to the targetted location ( target area and trigger 'wow_blink' cmd )" )
   register_clcmd( "wow_immolate", "wowmod_dmgspell_immolate", -1,
      "- WowMOD Spell: Attempts to hit your enemy with fire damage ( target enemy and trigger 'wow_immolate' cmd )" )
   register_clcmd( "wow_bolt", "wowmod_dmgspell_shadowbolt", -1,
      "- WowMOD Spell: Attempts to hit your enemy with shadow damage ( target enemy and trigger 'wow_bolt' cmd )" )
   register_clcmd( "wow_eviscerate", "wowmod_dmgspell_eviscerate", -1,
      "- WowMOD Spell: Attempts to land a killing blow with a knife ( trigger 'wow_eviscerate' cmd and then perform a knife attack )" )

   // Menu related entries follow
   register_menucmd( register_menuid( "\yWowMOD: Race Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_racemenu" )
   register_menucmd( register_menuid( "\yWowMOD: Nightelf Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<9), "wowmod_do_nelf_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Gnome Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<8)|(1<<9), "wowmod_do_gnome_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Dwarf Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<8)|(1<<9), "wowmod_do_dwarf_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Human Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<9), "wowmod_do_human_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Orc Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<8)|(1<<9), "wowmod_do_orc_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Tauren Class Selection"), 
      (1<<0)|(1<<1)|(1<<8)|(1<<9), "wowmod_do_tauren_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Undead Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<8)|(1<<9), "wowmod_do_undead_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Bloodelf Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<8)|(1<<9), "wowmod_do_belf_classmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Secondary Class Selection"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_class2menu" )
   register_menucmd( register_menuid( "\yWowMOD: Menu Pg2"), 1023, "wowmod_do_mainmenu2" )
   register_menucmd( register_menuid( "\yWowMOD: Main Menu"), 1023, "wowmod_do_mainmenu" )
   register_menucmd( register_menuid( "\yAdmin Menu"), 1023, "wowmod_do_adminmenu" )
   register_menucmd( register_menuid( "\yGive Players XP"), 1023, "wowmod_do_playerxpmenu" )
   register_menucmd( register_menuid( "\yAward Players Gold"), 1023, "wowmod_do_playergoldmenu" )
   register_menucmd( register_menuid( "\yTeam XP Menu"), 1023, "wowmod_do_teamxpmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Merchants Menu"), 1023, "wowmod_do_merchantmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Items Merchant"), 1023, "wowmod_do_itemmerch" )
   register_menucmd( register_menuid( "\yWowMOD: Armourer"), 1023, "wowmod_do_armourer" )
   register_menucmd( register_menuid( "\yResurrection Menu"), 1023, "wowmod_do_resurrect" )
   register_menucmd( register_menuid( "\yConfirm Race and Class Change"), 1023, "wowmod_do_changeconf" )
   register_menucmd( register_menuid( "\yConfirm Secondary Class Change"), 1023, "wowmod_do_changeconf2" )
   register_menucmd( register_menuid( "\yDisplay All Badges Menu"), 1023, "wowmod_do_allbadges" )
   register_menucmd( register_menuid( "\yWowMOD: Sell Back Spells Menu"), 1023, "wowmod_do_sellspellmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Sell Equipment Menu"), 1023, "wowmod_do_sellequipmenu" )
   register_menucmd( register_menuid( "\yWowMOD: Autocast Menu"), 1023, "wowmod_do_autocastmenu" )

   // Spell Merchant Menus
   register_menucmd( register_menuid("\yWowMOD: Spells and Skills Merchant"), 1023, "wowmod_do_spellmerchant")
   register_menucmd( register_menuid("\yWowMOD: Druid Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_druidspells")
   register_menucmd( register_menuid("\yWowMOD: Hunter Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_hunterspells")
   register_menucmd( register_menuid("\yWowMOD: Mage Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_magespells")
   register_menucmd( register_menuid("\yWowMOD: Rogue Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_roguespells")
   register_menucmd( register_menuid("\yWowMOD: Warlock Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_warlockspells")
   register_menucmd( register_menuid("\yWowMOD: Priest Spells Merchant"), 
      (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9), "wowmod_do_priestspells")

   // Event related entries follow - kept intact from UWC3
   register_event( "ResetHUD", "new_round", "b")
   register_event( "StatusValue", "showStatus", "be", "1=2", "2!0" )
   register_event( "StatusValue", "hideStatus", "be", "1=1", "2=0" )
   register_event( "DeathMsg", "death", "a" )
   register_event( "StatusValue", "setTeam", "be", "1=1" )
   register_event( "Damage", "damage_event", "b", "2!0" )
   register_event( "SendAudio", "T_win", "a", "2=%!MRAD_terwin" )
   register_event( "SendAudio", "CT_win", "a", "2=%!MRAD_ctwin" )
   register_event( "ArmorType", "armor_type", "be" )
   register_event( "CurWeapon", "change_weapon", "be", "1=1" )

   register_forward( FM_PlayerPreThink, "fwdPlayerPreThink" )

   // Log events: Requires AMX 0.9.3 or better - kept intact from UWC3
   register_logevent( "event_player_action", 3, "1=triggered" )
   register_logevent( "freezetimedone", 2, "0=World triggered", "1=Round_Start" )
   register_logevent( "end_round", 2, "0=World triggered", "1=Round_End" )


   register_cvar("amxx_wowmod", VER, FCVAR_SERVER)
   register_cvar("sv_wowmod_enabled", "1", FCVAR_SERVER)
   register_cvar("mp_savexp","1", FCVAR_SERVER)
   register_cvar("mp_sql","1")
   register_cvar("mp_sql_saveby","1")
   register_cvar("mp_sql_saveoncmdonly","0")
   register_cvar("mp_xpmultiplier","1.00")

   register_cvar("WOW_disable_adminmenu", "0")
   register_cvar("WOW_admin_mode", "0")
   register_cvar("WOW_admin_flag", "1048576")

   register_cvar("WOW_sql_host","127.0.0.1")
   register_cvar("WOW_sql_user","")
   register_cvar("WOW_sql_pass","")
   register_cvar("WOW_sql_db","wowmod")

   register_cvar("WOW_goldforkill","20")
   register_cvar("WOW_goldfordmg","5")
   register_cvar("WOW_goldforbomb","30")
   register_cvar("WOW_goldfordefuse","30")
   register_cvar("WOW_goldforrescue","20")
   register_cvar("WOW_goldforsupport","10")
   register_cvar("WOW_goldforwin","50")
   register_cvar("WOW_goldforassist","20")
   register_cvar("WOW_goldforassist2","100")
   register_cvar("WOW_goldforescape","50")
   register_cvar("WOW_goldforkillvip","50")
   register_cvar("WOW_goldforrez","100")
   register_cvar("WOW_dmgxpbonus","20")

   register_cvar("WOW_badge_div","100.0")
   register_cvar("WOW_gold_fastxp","100")

   register_cvar("WOW_dualclass_level","30")
   register_cvar("WOW_dualclass_numspells","20")

   register_cvar("WOW_classicons","1")
   register_cvar("WOW_blink_punish","1")

   // CVARS kept from UWC3
   // _XP bonus settings are / by 3 for shortterm XP and 10 for saved XP
   register_cvar("UW_medicalerts","2")
   register_cvar("UW_HEALTHBONUS","10")

   register_cvar("WOW_mend_XP","100")
   register_cvar("WOW_prayer_XP","150")
   register_cvar("WOW_remcurse_XP","100")
   register_cvar("WOW_gift_XP","100")
   register_cvar("WOW_tranq_XP","200")
   register_cvar("WOW_assist_XP","40")
   register_cvar("WOW_rez_XP","200")

   // CVARS kept from War3FT 
   register_cvar("FT_round_win_XP","25")
   register_cvar("FT_hostage_touch_bonus","0")
   register_cvar("FT_attempt_defuse_bonus","0")
   register_cvar("FT_bomb_event_bonus","0")
   register_cvar("FT_VIP_spawn_bonus","0")
   register_cvar("FT_hostage_kill_xp","0")
   register_cvar("FT_headshot_bonus","20")
   register_cvar("FT_defuser_kill_bonus","20")
   register_cvar("FT_VIP_escape_bonus","20")
   register_cvar("FT_hostage_touch_bonus","0")
   register_cvar("FT_ultimatedelay", "0")
   register_cvar("FT_objectives", "1")
   register_cvar("FT_bombplanterxp","20")
   register_cvar("FT_xp_radius","750")
   register_cvar("FT_defusexp","20")
   register_cvar("FT_hostagexp","20")
   register_cvar("FT_killrescuemanxp","20")
   register_cvar("FT_min_b4_XP","2")
   register_cvar("FT_centerhud","1")

   // set_task calls for functions needed by init or to run continuously
   set_task( 10.0, "check_wowmod_enabled", TASK_CHKENABLED_LOOP, "", 0, "b" )
   set_task( 1.0, "check_wowmod_enabled", TASK_CHKENABLED )
   set_task( 3.0, "set_xpfrontend", TASK_SETXP )
   set_task( 1.2, "set_variables", TASK_SETVARS )
   set_task( 1.6, "check_sql", TASK_SQLINIT )
   set_task( 3.4, "wowmod_gear_init", TASK_GEARINIT )
   set_task( 3.6, "wowmod_badge_init", TASK_BADGEINIT )
   set_task( 3.8, "wowmod_specabil_init", TASK_SPECABILINIT )

   new basedir[64]
   new cfgfile[64]
   get_customdir(basedir, 63)
   format( cfgfile, 63, "%s/WowMOD/WowMOD.cfg", basedir)

   if ( file_exists( cfgfile ) ){
      log_amx( "WowMOD Startup :: Loading Configuration File [ WowMOD.cfg ]..." )
      server_cmd( "exec %s", cfgfile )
      log_amx( "WowMOD Startup :: Configuration File Loaded [OK]" )
   }else{
      log_amx( "WowMOD Startup :: Configuration File NOT FOUND [ Using Default settings ]" )
   }

   log_amx( "WowMOD Startup :: Configuration Info: Races " )
   for( new i = RACE_NIGHTELF; i < NUM_RACES; i++ ){
      log_amx( "WowMOD Startup :: Race Installed: %s", races[i] )
   }

   log_amx( "WowMOD Startup :: Configuration Info: Classes " )
   for( new i = CLASS_DRUID; i < NUM_CLASSES; i++ ){
      log_amx( "WowMOD Startup :: Class Installed: %s", classes[i] )
   }


}


// **************************************************************************
// BEGIN plugin_modules subroutine - Kept from UWC3
// Specify which modules are required by WowMOD 
// **************************************************************************
public plugin_modules(){
   require_module("engine")   // Requires the engine module
   require_module("fun")   // Requires the fun module
   require_module("cstrike")  // Requires the cstrike module
   require_module("dbi")   // Requires the dbi module
}


// **************************************************************************
// BEGIN client_connect subroutine - Kept from UWC3
// A new client has connected
// **************************************************************************
public client_connect(id){
   client_cmd(id, "hud_centerid 0")
   g_specMode[id] = false

   init_pdata( id, 0 )  // Initialize player data (NOT limited init mode)

   // Set the flag to display the Main WowMOD menu
   client_ready_mainmenu[id] = true

   // If we are saving player data set flag to load this player
   if (get_cvar_num("mp_savexp"))
      readytoload[id] = true 

   client_cmd(id, "echo ")
   client_cmd(id, "echo ^" *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=* ^" ")
   client_cmd(id, "echo ^" *=-= Welcome to World of Warcraft Mod (WowMOD) ^" ")
   client_cmd(id, "echo ^" *=-=    by K2mia ^" ")
   client_cmd(id, "echo ^" *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=* ^" ")
   client_cmd(id, "echo ")

   return PLUGIN_CONTINUE
}


// **************************************************************************
// BEGIN client_disconnect subroutine
// A client has disconnected
// **************************************************************************
public client_disconnect(id){
   loadedlevel[id] = 0           // Reset status for having initial level loaded
   manahud_running[id] = false   // Reset manahud_running for userid
   g_specMode[id] = false        // Reset spectator status for player

   if ( p_xp[id] < 100 )
      return PLUGIN_CONTINUE

   // Kill all running tasks for this player
   wowmod_kill_tasks( id )

   if ( get_cvar_num("mp_savexp") && !is_user_bot(id) && p_xp[id] ){
      if (get_cvar_num("mp_sql"))
         sqlwrite_id(id)
      else
         write_id(id)

      readytoload[id] = false 
   }


   return PLUGIN_CONTINUE
}


// **************************************************************************
// BEGIN client_putinserver subroutine 
// The client has been put into the server 
// **************************************************************************
public client_putinserver(id){
   readytoload[id] = true

   // Check for players ready to load from storage
   if ( get_cvar_num("mp_savexp") ){
      if ( get_cvar_num("mp_sql") ){
         sqlload_id(id)
      }else{
         load_id(id)

         if ( readytoload[id] ){
            // Player data failed to load, display start menu
            wowmod_display_racemenu( id )
            //readytoload[id] = false
         }
      }
   }

   new playerid[32]
   get_user_authid( id, playerid, 31 )

   if ( get_user_flags(id) & get_cvar_num("WOW_admin_flag") )
      log_amx( "[%s] Client [%d] connected... ( Admin account )", MOD, id )
   else
      log_amx( "[%s] Client [%d] connected... ( Player account )", MOD, id )

}


// **************************************************************************
// BEGIN plugin_precache subroutine
// Specify resources to be precached on client side
// **************************************************************************
public plugin_precache() {
   blood1 = precache_model("sprites/blood.spr")
   blood2 = precache_model("sprites/bloodspray.spr")

   lightning = precache_model("sprites/lgtning.spr")
   burning = precache_model("sprites/xfire.spr")
   frostbolt = precache_model("sprites/frostbolt.spr")
   blast = precache_model("sprites/blast2.spr")
   blizzard = precache_model("sprites/blizzard4.spr")

   // Class icons
   class_druid = precache_model("sprites/classes/class_druid2.spr")
   class_hunter = precache_model("sprites/classes/class_hunter2.spr")
   class_mage = precache_model("sprites/classes/class_mage2.spr")
   class_rogue = precache_model("sprites/classes/class_rogue2.spr")
   class_warlock = precache_model("sprites/classes/class_warlock2.spr")
   class_priest = precache_model("sprites/classes/class_priest3.spr")

   // [09-02-04] Added sprites for medic, shield and combo, and other effects
   medicspr = precache_model("sprites/medic3.spr")
   gatespr = precache_model("sprites/gate1.spr")

   if (file_exists("models/roots2.mdl"))
      precache_model("models/roots2.mdl")

   precache_sound("ambience/particle_suck1.wav")
   precache_sound("turret/tu_ping.wav")
   precache_sound("weapons/cbar_hitbod3.wav")

   // New sounds added for UWC3 / WowMOD
   precache_sound("ambience/flameburst1.wav")
   precache_sound("scientist/scream07.wav")
   precache_sound("buttons/button10.wav")
   precache_sound("fans/fan5.wav")
   precache_sound("items/medshot5.wav")
   precache_sound("items/suitchargeok1.wav")
   precache_sound("wowmod/blizzard.wav")
   precache_sound("wowmod/searching.wav")
   precache_sound("wowmod/berzerk4.wav")

   if (file_exists("sound/wowmod/banishcaster.wav"))
      precache_sound("wowmod/banishcaster.wav")
   if (file_exists("sound/wowmod/antend.wav"))
      precache_sound("wowmod/antend.wav")
   if (file_exists("sound/wowmod/tomes.wav"))
      precache_sound("wowmod/tomes.wav")
   if (file_exists("sound/wowmod/locustswarmloopwav.wav"))
      precache_sound("wowmod/locustswarmloopwav.wav")
   if (file_exists("sound/wowmod/impalelaunch1.wav"))
      precache_sound("wowmod/impalelaunch1.wav")
   if (file_exists("sound/wowmod/shadowstrikemissile1.wav"))
      precache_sound("wowmod/shadowstrikemissile1.wav")
   if (file_exists("sound/wowmod/locustswarmloop.wav"))
      precache_sound("wowmod/locustswarmloop.wav")
   if (file_exists("sound/wowmod/soundpack/reincarnation.wav"))
      precache_sound("wowmod/soundpack/reincarnation.wav")
   if (file_exists("sound/wowmod/shadowstrikebirth1.wav"))
      precache_sound("wowmod/shadowstrikebirth1.wav")
   if (file_exists("sound/wowmod/carrionswarmdamage1.wav"))
      precache_sound("wowmod/carrionswarmdamage1.wav")
   if (file_exists("sound/wowmod/carrionswarmlaunch1.wav"))
      precache_sound("wowmod/carrionswarmlaunch1.wav")
   if (file_exists("sound/wowmod/impalehit.wav"))
      precache_sound("wowmod/impalehit.wav")
   if (file_exists("sound/wowmod/divineshield.wav"))
      precache_sound("wowmod/divineshield.wav")
   if (file_exists("sound/wowmod/flamestrike.wav"))
      precache_sound("wowmod/flamestrike.wav")
   if (file_exists("sound/wowmod/spellcast.wav"))
      precache_sound("wowmod/spellcast.wav")
   if (file_exists("sound/wowmod/entanglingrootstarget1.wav"))
      precache_sound("wowmod/entanglingrootstarget1.wav")
   else{
      precache_sound("weapons/electro5.wav")
      precache_sound("weapons/cbar_hitbod3.wav")
   }
   if (file_exists("sound/wowmod/levelupcaster.wav"))
      precache_sound("wowmod/levelupcaster.wav")
   else
      precache_sound("plats/elevbell1.wav")

   if (file_exists("sound/wowmod/lightningbolt.wav"))
      precache_sound("wowmod/lightningbolt.wav")
   else
      precache_sound("weapons/gauss2.wav")

   if (file_exists("sound/wowmod/massteleporttarget.wav"))
      precache_sound("wowmod/massteleporttarget.wav")
   else
      precache_sound("x/x_shoot1.wav")

   if (file_exists("sound/wowmod/blinkarrival.wav"))
      precache_sound("wowmod/blinkarrival.wav")
   else
      precache_sound("x/x_shoot1.wav")

   if (file_exists("sound/wowmod/pickupitem.wav"))
      precache_sound("wowmod/pickupitem.wav")

   if (file_exists("sound/wowmod/biggun2.wav"))
      precache_sound("wowmod/biggun2.wav")

   // Precache std CS player models for use with decoy ability
   precache_model("models/player/leet/leet.mdl")
   precache_model("models/player/arctic/arctic.mdl")
   precache_model("models/player/guerilla/guerilla.mdl")
   precache_model("models/player/terror/terror.mdl")

   precache_model("models/player/gign/gign.mdl")
   precache_model("models/player/sas/sas.mdl")
   precache_model("models/player/gsg9/gsg9.mdl")
   precache_model("models/player/urban/urban.mdl")

   precache_model("models/player/vip/vip.mdl")
   precache_model("models/guerilla.mdl")

   return PLUGIN_CONTINUE
}


// **************************************************************************
// BEGIN fwdPlayerPreThink subroutine
// PreThink hook
// **************************************************************************
public fwdPlayerPreThink(id){

   //client_print( id, print_chat, ">>In PreThink() 1" )
   new shield_offset = get_pdata_int(id, OFFSET_SHIELD)

   new shield = false

   if ( ( shield_offset & HAS_SHIELD ) && ( shield_offset & USING_SHIELD ) ){
      shield = true
   }

   if ( ctshieldon[id] && !shield ){
      ctshieldon[id] = false 
      //client_print( id, print_chat, ">>In PreThink() - No longer using shield" )

      new parm[1]
      parm[0] = id
      set_task( 0.1, "wowmod_cheetah", TASK_ACHEETAH, parm, 1 )
   }else if ( !ctshieldon[id] && shield ){
      ctshieldon[id] = true
      //client_print( id, print_chat, ">>In PreThink() - Now using shield" )

      new parm[1]
      parm[0] = id
      set_task( 0.1, "wowmod_cheetah", TASK_ACHEETAH, parm, 1 )
   }

   return PLUGIN_CONTINUE
}


// **************************************************************************
// BEGIN set_variables subroutine
// Setup variables and use cvar data where applicable
// **************************************************************************
public set_variables(){

   // Setup html head/css text
   new pos = 0
   pos += format( html_head[pos], 500-pos, "<html><head><style type='text/css'>" )
   pos += format( html_head[pos], 500-pos, "body { background:#000000; color: #FFB000; margin-left:6px; margin-right: 6px; margin-top:3px; font-family:Verdana,Tahoma; font-size: 12px;  }" )
   pos += format( html_head[pos], 500-pos, "a { text-decoration: underline; }" )
   pos += format( html_head[pos], 500-pos, "li { font-family:Verdana,Tahoma; font-size: 12px; " )
   pos += format( html_head[pos], 500-pos, "table { width: 800px; " )
   pos += format( html_head[pos], 500-pos, "td { background:#000000; color: #FFB000; font-family:Verdana,Tahoma; font-size: 12px; padding: 6px; " )
   pos += format( html_head[pos], 500-pos, "</style></head>" )


   BOMBPLANTXP = get_cvar_num("FT_bombplanterxp")
   DEFUSEXP = get_cvar_num("FT_defusexp")
   HOSTAGEXP = get_cvar_num("FT_hostagexp")
   KILLRESCUEMANXP = get_cvar_num("FT_killrescuemanxp")
   XPBONUS = get_cvar_num("FT_xpbonus")
   KILL_BOMB_CARRIER = get_cvar_num("FT_kill_bomb_carrier_bonus")
   HEADSHOT_BONUS = get_cvar_num("FT_headshot_bonus")
   DEFUSER_KILL_BONUS = get_cvar_num("FT_defuser_kill_bonus")
   VIP_ESCAPE_BONUS = get_cvar_num("FT_VIP_escape_bonus")
   ROUNDXP = get_cvar_num("FT_round_win_XP")
   MENDXP = get_cvar_num("WOW_mend_XP")
   PRAYERXP = get_cvar_num("WOW_prayer_XP")
   REMCURSEXP = get_cvar_num("WOW_remcurse_XP")
   GIFTXP = get_cvar_num("WOW_gift_XP")
   TRANQXP = get_cvar_num("WOW_tranq_XP")
   ASSISTXP = get_cvar_num("WOW_assist_XP")
   REZXP = get_cvar_num("WOW_rez_XP")

   HEALTHBONUS = get_cvar_num("UW_HEALTHBONUS")

   DUAL_CLASS_LEVEL = get_cvar_num("WOW_dualclass_level")
   DUAL_CLASS_NUMSPELLS = get_cvar_num("WOW_dualclass_numspells")

   BADGE_DIV = get_cvar_float("WOW_badge_div")

   GOLD_FASTXP_MULT = get_cvar_num("WOW_gold_fastxp")

   GOLD_KILL = get_cvar_num("WOW_goldforkill")
   GOLD_DMG = get_cvar_num("WOW_goldfordmg")
   GOLD_BOMB = get_cvar_num("WOW_goldforbomb")
   GOLD_DEFUSE = get_cvar_num("WOW_goldfordefuse")
   GOLD_RESCUE = get_cvar_num("WOW_goldforrescue")
   GOLD_SUPPORT = get_cvar_num("WOW_goldforsupport")
   GOLD_WIN = get_cvar_num("WOW_goldforwin")
   GOLD_ESCAPE = get_cvar_num("WOW_goldforescape")
   GOLD_KILLVIP = get_cvar_num("WOW_goldforkillvip")
   GOLD_ASSIST = get_cvar_num("WOW_goldforassist")
   GOLD_ASSIST2 = get_cvar_num("WOW_goldforassist2")
   GOLD_REZ = get_cvar_num("WOW_goldforrez")

}


// **************************************************************************
// BEGIN client_prethink subroutine - kept from UWC3
// Prethink routines
// **************************************************************************
public client_PreThink(id) {
   if ( is_user_connected( id ) )
      entity_set_float(id, EV_FL_fuser2, 0.0)  // Disable slow down after jumping
}


// **************************************************************************
// END World of Warcraft Mod WowMOD Module 
// **************************************************************************

