// DRACULA!

/* CVARS - copy and paste to shconfig.cfg

//Dracula
dracula_level 0
dracula_pctperlev 0.03	//What percent of damage to give back per level of player

*/

// v1.17.5 - JTP - Added code to allow you to regen to your max heatlh

#include <amxmod>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Dracula"
new bool:gHasDraculaPowers[SH_MAXSLOTS+1]
new gPlayerLevels[SH_MAXSLOTS+1]
new gPlayerMaxHealth[SH_MAXSLOTS+1]

//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Dracula","1.18","{HOJ} Batman/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("dracula_level", "0" )
	register_cvar("dracula_pctperlev", "0.03" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Vampiric Drain", "Gain HP by shooting people - More HPs per level", false, "dracula_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)

	// INIT
	register_srvcmd("dracula_init", "dracula_init")
	shRegHeroInit(gHeroName, "dracula_init")

	// LEVELS
	register_srvcmd("dracula_levels", "dracula_levels")
	shRegLevels(gHeroName,"dracula_levels")

	// GET MORE ENERGY!
	register_event("Damage", "dracula_damage", "b", "2!0")

	//Makes superhero tell dracula a players max health
	register_srvcmd("dracula_maxhealth", "dracula_maxhealth")
	shRegMaxHealth(gHeroName, "dracula_maxhealth" )
}
//----------------------------------------------------------------------------------------------
public dracula_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has dracula skills
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	gPlayerMaxHealth[id] = 100
	gHasDraculaPowers[id] = (hasPowers!=0)
}
//----------------------------------------------------------------------------------------------
public dracula_levels()
{
	new id[5]
	new lev[5]

	read_argv(1,id,4)
	read_argv(2,lev,4)

	gPlayerLevels[str_to_num(id)] = str_to_num(lev)
}
//----------------------------------------------------------------------------------------------
public dracula_damage(id)
{
	if (!shModActive() || !is_user_connected(id)) return

	new damage = read_data(2)
	new attacker = get_user_attacker(id)

	if ( attacker <= 0 || attacker > SH_MAXSLOTS ) return

	if ( gHasDraculaPowers[attacker] && is_user_alive(attacker) && attacker != id ) {
		//Add some HP back!
		new giveHPs = floatround( damage * get_cvar_float("dracula_pctperlev") * gPlayerLevels[attacker] )
		if (get_user_health(attacker) < gPlayerMaxHealth[attacker] && giveHPs > 0 ) {
			new alphanum = damage * 2
			if (alphanum > 200) alphanum = 200
			else if (alphanum < 40) alphanum = 40
			setScreenFlash(attacker, 255, 10, 10, 10, alphanum )  //Red Screen Flash
			shAddHPs(attacker, giveHPs, gPlayerMaxHealth[attacker] )

		}
	}
}
//----------------------------------------------------------------------------------------------
public dracula_maxhealth()
{
	new id[6]
	new health[9]

	read_argv(1,id,5)
	read_argv(2,health,8)

	gPlayerMaxHealth[str_to_num(id)] = str_to_num(health)
}
//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gHasDraculaPowers[id] = false
}
//----------------------------------------------------------------------------------------------